// Geometric Tools, LLC
// Copyright (c) 1998-2014
// Distributed under the Boost Software License, Version 1.0.
// http://www.boost.org/LICENSE_1_0.txt
// http://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
//
// File Version: 5.0.1 (2010/10/01)

#ifndef WM5DISTLINE4TRIANGLE3_H
#define WM5DISTLINE4TRIANGLE3_H

#include "Wm5MathematicsLIB.h"
#include "Wm5Distance.h"
#include "Wm5Line3.h"
#include "Wm5Triangle3.h"

namespace Wm5
{

template <typename Real>
class WM5_MATHEMATICS_ITEM DistLine3Triangle3
    : public Distance<Real,Vector3<Real> >
{
public:
    DistLine3Triangle3 (const Line3<Real>& line,
        const Triangle3<Real>& triangle);

    // Object access.
    const Line3<Real>& GetLine () const;
    const Triangle3<Real>& GetTriangle () const;

    // Static distance queries.
    virtual Real Get ();
    virtual Real GetSquared ();

    // Function calculations for dynamic distance queries.
    virtual Real Get (Real t, const Vector3<Real>& velocity0,
        const Vector3<Real>& velocity1);
    virtual Real GetSquared (Real t, const Vector3<Real>& velocity0,
        const Vector3<Real>& velocity1);

    // Information about the closest points.
    Real GetLineParameter () const;
    Real GetTriangleBary (int i) const;

private:
    using Distance<Real,Vector3<Real> >::mClosestPoint0;
    using Distance<Real,Vector3<Real> >::mClosestPoint1;

    const Line3<Real>* mLine;
    const Triangle3<Real>* mTriangle;

    // Information about the closest points.

    // closest0 = line.origin + param*line.direction
    Real mLineParameter;

    // closest1 = sum_{i=0}^2 bary[i]*tri.vertex[i]
    Real mTriangleBary[3];
};

typedef DistLine3Triangle3<float> DistLine3Triangle3f;
typedef DistLine3Triangle3<double> DistLine3Triangle3d;

}

#endif
