/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef WALLPAPERUI_H
#define WALLPAPERUI_H

#include "previewlabel.h"
#include "titlelabel.h"
#include "fixlabel.h"
#include "settinggroup.h"
#include "ukccframe.h"
#include "addbutton.h"
#include "comboxwidget.h"
#include "pictureunit.h"
#include "flowlayout.h"
#include "colordialog.h"
#include <QWidget>
#include <QVBoxLayout>
#include <QLineEdit>
#include <QRadioButton>
#include <QButtonGroup>

class WallpaperUi : public QWidget
{
    Q_OBJECT
public:
    WallpaperUi();
    ~WallpaperUi();

public:
    void setWallpaperModes(const QStringList &modeList, const QStringList &modeDataList);
    void setDisplayTypes(const QStringList &typeList, const QStringList &typeDataList);
    void setWallpaperMode(const QString &mode, const QString &data);
    void setDisplayType(const QString &type);
    void setPicturesFile(QList<PictureInfo*> picInfoList); // 压缩文件、源文件
    void showPictures();
    void showColors();

// 初始化
private:
    void initUi();
    void initColors();
    void createObject();
    void initSignals();
    void resetClickedPic();

private:
    void createPictureUnit(PictureUnit* picUnit, const bool &clicked);

private:
    QVBoxLayout *uiLayout      = nullptr;

private:
    TitleLabel   *wallpaperTitleLabel = nullptr;
    PreviewLabel *previewLabel        = nullptr;

private:
    SettingGroup *settingGroup    = nullptr;
    ComboxWidget *modeWidget      = nullptr;
    ComboxWidget *typeWidget      = nullptr;
    SettingGroup *colorGroup      = nullptr;
    UkccFrame    *addbuttonFrame  = nullptr;
    QHBoxLayout  *addbuttonlayout = nullptr;
    AddButton    *colorAddButton  = nullptr;
    UkccFrame    *colorFrame      = nullptr;
    FlowLayout   *colorLayout     = nullptr;
    UkccFrame    *picBtnFrame     = nullptr;
    UkccFrame    *picFrame        = nullptr;
    FlowLayout   *pictureLayout   = nullptr;
    UkccFrame    *bottomFrame     = nullptr;
    QPushButton  *localBtn        = nullptr;
    QPushButton  *onlineBtn       = nullptr;
    QPushButton  *resetBtn        = nullptr;

private:
    QString     currentFile;
    PictureUnit *prePictureUnit = nullptr;

Q_SIGNALS:
    void wallpaperChanged(const QString &mode, const QString &data);
    void typeChanged(const QString &type);
    void localButtonClicked();
    void onlineButtonClicked();
    void resetButtonClicked();
    void colorAddButtonClicked();
};



#endif // WALLPAPERUI_H
