/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef DATEEDIT_H
#define DATEEDIT_H
#include <QDateEdit>
#include <QStyle>
#include <QDBusInterface>

class DateEdit : public QDateEdit {
    Q_OBJECT
public :
    DateEdit(QWidget *parent = nullptr);
    ~DateEdit();
    QPixmap loadSvg(const QString &path, int size);
    QPixmap drawSymbolicColoredPixmap(const QPixmap &source);
private Q_SLOTS:
    void mode_change_signal_slots(bool b);
protected:
    void paintEvent(QPaintEvent *e);
    bool eventFilter(QObject *obj, QEvent *event) override;
private:
    bool hoverFlag = false;
    bool focusFlag = false;
    QDBusInterface *m_statusSessionDbus = nullptr;
Q_SIGNALS:
    void changeDate();
};

#endif // DATEEDIT_H
