// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UMULL_4S_TRACE_AARCH64_H_
#define VIXL_SIM_UMULL_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_umull_4S[] = {
  0x00003e04, 0x00003f01, 0x0a3d5c29, 0x1c718e39,
  0x00003e82, 0x0019664d, 0x1110eeef, 0x2aa98001,
  0x0019331a, 0x002a552b, 0x1998e667, 0x2aa9d556,
  0x0029ffd6, 0x003f7e83, 0x1999199a, 0x2aaa2aab,
  0x003efe86, 0x003f7f02, 0x19994ccd, 0x00000000,
  0x003eff04, 0x003f7f81, 0x00000000, 0x00005555,
  0x003eff82, 0x00000000, 0x00003333, 0x0000aaaa,
  0x00000000, 0x0000007f, 0x00006666, 0x00055550,
  0x0000007e, 0x000000fe, 0x00033330, 0x0029aa81,
  0x000000fc, 0x000007f0, 0x0018ffe7, 0x0029ffd6,
  0x000007e0, 0x00003e03, 0x0019331a, 0x002a552b,
  0x00003d86, 0x00003e82, 0x0019664d, 0x1110eeef,
  0x00003e04, 0x00003f01, 0x0a3d5c29, 0x1c718e39,
  0x00003e82, 0x0019664d, 0x1110eeef, 0x2aa98001,
  0x0019331a, 0x002a552b, 0x1998e667, 0x2aa9d556,
  0x0029ffd6, 0x003f7e83, 0x1999199a, 0x2aaa2aab,
  0x003efe86, 0x003f7f02, 0x19994ccd, 0x2aaa8000,
  0x003eff04, 0x003f7f81, 0x19998000, 0x2aaad555,
  0x003eff82, 0x003f8000, 0x1999b333, 0x38e31c72,
  0x003f0000, 0x003f807f, 0x2221ddde, 0x4443bbbc,
  0x003f007e, 0x0054aa56, 0x28f570a4, 0x552a5580,
  0x0053ffac, 0x00659934, 0x33196680, 0x552aaad5,
  0x0064cc68, 0x007ec080, 0x331999b3, 0x552b002a,
  0x007dc100, 0x007ec0ff, 0x3319cce6, 0x552b557f,
  0x007ec0ff, 0x3319cce6, 0x552b557f, 0x7ff50030,
  0x007ec17e, 0x331a0019, 0x554faab0, 0x7ffb8009,
  0x007ec1fd, 0x332fccd0, 0x55540001, 0x7ffc0006,
  0x007ef810, 0x33326667, 0x55545556, 0x7ffc8003,
  0x007efe83, 0x3332999a, 0x5554aaab, 0x00000000,
  0x007eff02, 0x3332cccd, 0x00000000, 0x00007ffd,
  0x007eff81, 0x00000000, 0x00005555, 0x0000fffa,
  0x00000000, 0x00003333, 0x0000aaaa, 0x0007ffd0,
  0x0000007f, 0x00006666, 0x00055550, 0x003e7e89,
  0x000000fe, 0x00033330, 0x0029aa81, 0x003efe86,
  0x000007f0, 0x0018ffe7, 0x0029ffd6, 0x003f7e83,
  0x00003e03, 0x0019331a, 0x002a552b, 0x1998e667,
  0x00003e82, 0x0019664d, 0x1110eeef, 0x2aa98001,
  0x00003f01, 0x0a3d5c29, 0x1c718e39, 0x3ffd0009,
  0x0019664d, 0x1110eeef, 0x2aa98001, 0x3ffd8006,
  0x002a552b, 0x1998e667, 0x2aa9d556, 0x3ffe0003,
  0x003f7e83, 0x1999199a, 0x2aaa2aab, 0x3ffe8000,
  0x003f7f02, 0x19994ccd, 0x2aaa8000, 0x3ffefffd,
  0x003f7f81, 0x19998000, 0x2aaad555, 0x55530002,
  0x003f8000, 0x1999b333, 0x38e31c72, 0x6663999c,
  0x003f807f, 0x2221ddde, 0x4443bbbc, 0x7fbd0180,
  0x0054aa56, 0x28f570a4, 0x552a5580, 0x7fbd817d,
  0x00659934, 0x33196680, 0x552aaad5, 0x7fbe017a,
  0x007ec080, 0x331999b3, 0x552b002a, 0x7fbe8177,
  0x331999b3, 0x552b002a, 0x7fbe8177, 0x7ff60020,
  0x3319cce6, 0x552b557f, 0x7ff50030, 0x7ffc8006,
  0x331a0019, 0x554faab0, 0x7ffb8009, 0x7ffd0004,
  0x332fccd0, 0x55540001, 0x7ffc0006, 0x7ffd8002,
  0x33326667, 0x55545556, 0x7ffc8003, 0x00000000,
  0x3332999a, 0x5554aaab, 0x00000000, 0x00007ffe,
  0x3332cccd, 0x00000000, 0x00007ffd, 0x0000fffc,
  0x00000000, 0x00005555, 0x0000fffa, 0x0007ffe0,
  0x00003333, 0x0000aaaa, 0x0007ffd0, 0x003e7f06,
  0x00006666, 0x00055550, 0x003e7e89, 0x003eff04,
  0x00033330, 0x0029aa81, 0x003efe86, 0x003f7f02,
  0x0018ffe7, 0x0029ffd6, 0x003f7e83, 0x1999199a,
  0x0019331a, 0x002a552b, 0x1998e667, 0x2aa9d556,
  0x0019664d, 0x1110eeef, 0x2aa98001, 0x3ffd8006,
  0x0a3d5c29, 0x1c718e39, 0x3ffd0009, 0x3ffe0004,
  0x1110eeef, 0x2aa98001, 0x3ffd8006, 0x3ffe8002,
  0x1998e667, 0x2aa9d556, 0x3ffe0003, 0x3fff0000,
  0x1999199a, 0x2aaa2aab, 0x3ffe8000, 0x3fff7ffe,
  0x19994ccd, 0x2aaa8000, 0x3ffefffd, 0x5553aaac,
  0x19998000, 0x2aaad555, 0x55530002, 0x66646668,
  0x1999b333, 0x38e31c72, 0x6663999c, 0x7fbe0100,
  0x2221ddde, 0x4443bbbc, 0x7fbd0180, 0x7fbe80fe,
  0x28f570a4, 0x552a5580, 0x7fbd817d, 0x7fbf00fc,
  0x33196680, 0x552aaad5, 0x7fbe017a, 0x7fbf80fa,
  0x552aaad5, 0x7fbe017a, 0x7fbf80fa, 0x7ff70010,
  0x552b002a, 0x7fbe8177, 0x7ff60020, 0x7ffd8003,
  0x552b557f, 0x7ff50030, 0x7ffc8006, 0x7ffe0002,
  0x554faab0, 0x7ffb8009, 0x7ffd0004, 0x7ffe8001,
  0x55540001, 0x7ffc0006, 0x7ffd8002, 0x00000000,
  0x55545556, 0x7ffc8003, 0x00000000, 0x00007fff,
  0x5554aaab, 0x00000000, 0x00007ffe, 0x0000fffe,
  0x00000000, 0x00007ffd, 0x0000fffc, 0x0007fff0,
  0x00005555, 0x0000fffa, 0x0007ffe0, 0x003e7f83,
  0x0000aaaa, 0x0007ffd0, 0x003e7f06, 0x003eff82,
  0x00055550, 0x003e7e89, 0x003eff04, 0x003f7f81,
  0x0029aa81, 0x003efe86, 0x003f7f02, 0x19994ccd,
  0x0029ffd6, 0x003f7e83, 0x1999199a, 0x2aaa2aab,
  0x002a552b, 0x1998e667, 0x2aa9d556, 0x3ffe0003,
  0x1110eeef, 0x2aa98001, 0x3ffd8006, 0x3ffe8002,
  0x1c718e39, 0x3ffd0009, 0x3ffe0004, 0x3fff0001,
  0x2aa98001, 0x3ffd8006, 0x3ffe8002, 0x3fff8000,
  0x2aa9d556, 0x3ffe0003, 0x3fff0000, 0x3fffffff,
  0x2aaa2aab, 0x3ffe8000, 0x3fff7ffe, 0x55545556,
  0x2aaa8000, 0x3ffefffd, 0x5553aaac, 0x66653334,
  0x2aaad555, 0x55530002, 0x66646668, 0x7fbf0080,
  0x38e31c72, 0x6663999c, 0x7fbe0100, 0x7fbf807f,
  0x4443bbbc, 0x7fbd0180, 0x7fbe80fe, 0x7fc0007e,
  0x552a5580, 0x7fbd817d, 0x7fbf00fc, 0x7fc0807d,
  0x7fbd817d, 0x7fbf00fc, 0x7fc0807d, 0x00000000,
  0x7fbe017a, 0x7fbf80fa, 0x7ff70010, 0x00000000,
  0x7fbe8177, 0x7ff60020, 0x7ffd8003, 0x00000000,
  0x7ff50030, 0x7ffc8006, 0x7ffe0002, 0x00000000,
  0x7ffb8009, 0x7ffd0004, 0x7ffe8001, 0x00000000,
  0x7ffc0006, 0x7ffd8002, 0x00000000, 0x00000000,
  0x7ffc8003, 0x00000000, 0x00007fff, 0x00000000,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x00000000,
  0x00007ffd, 0x0000fffc, 0x0007fff0, 0x00000000,
  0x0000fffa, 0x0007ffe0, 0x003e7f83, 0x00000000,
  0x0007ffd0, 0x003e7f06, 0x003eff82, 0x00000000,
  0x003e7e89, 0x003eff04, 0x003f7f81, 0x00000000,
  0x003efe86, 0x003f7f02, 0x19994ccd, 0x00000000,
  0x003f7e83, 0x1999199a, 0x2aaa2aab, 0x00000000,
  0x1998e667, 0x2aa9d556, 0x3ffe0003, 0x00000000,
  0x2aa98001, 0x3ffd8006, 0x3ffe8002, 0x00000000,
  0x3ffd0009, 0x3ffe0004, 0x3fff0001, 0x00000000,
  0x3ffd8006, 0x3ffe8002, 0x3fff8000, 0x00000000,
  0x3ffe0003, 0x3fff0000, 0x3fffffff, 0x00000000,
  0x3ffe8000, 0x3fff7ffe, 0x55545556, 0x00000000,
  0x3ffefffd, 0x5553aaac, 0x66653334, 0x00000000,
  0x55530002, 0x66646668, 0x7fbf0080, 0x00000000,
  0x6663999c, 0x7fbe0100, 0x7fbf807f, 0x00000000,
  0x7fbd0180, 0x7fbe80fe, 0x7fc0007e, 0x00000000,
  0x7fbe80fe, 0x7fc0007e, 0x00000000, 0x0000fff0,
  0x7fbf00fc, 0x7fc0807d, 0x00000000, 0x0000fffd,
  0x7fbf80fa, 0x7ff70010, 0x00000000, 0x0000fffe,
  0x7ff60020, 0x7ffd8003, 0x00000000, 0x0000ffff,
  0x7ffc8006, 0x7ffe0002, 0x00000000, 0x00000000,
  0x7ffd0004, 0x7ffe8001, 0x00000000, 0x00000001,
  0x7ffd8002, 0x00000000, 0x00000000, 0x00000002,
  0x00000000, 0x00007fff, 0x00000000, 0x00000010,
  0x00007ffe, 0x0000fffe, 0x00000000, 0x0000007d,
  0x0000fffc, 0x0007fff0, 0x00000000, 0x0000007e,
  0x0007ffe0, 0x003e7f83, 0x00000000, 0x0000007f,
  0x003e7f06, 0x003eff82, 0x00000000, 0x00003333,
  0x003eff04, 0x003f7f81, 0x00000000, 0x00005555,
  0x003f7f02, 0x19994ccd, 0x00000000, 0x00007ffd,
  0x1999199a, 0x2aaa2aab, 0x00000000, 0x00007ffe,
  0x2aa9d556, 0x3ffe0003, 0x00000000, 0x00007fff,
  0x3ffd8006, 0x3ffe8002, 0x00000000, 0x00008000,
  0x3ffe0004, 0x3fff0001, 0x00000000, 0x00008001,
  0x3ffe8002, 0x3fff8000, 0x00000000, 0x0000aaaa,
  0x3fff0000, 0x3fffffff, 0x00000000, 0x0000cccc,
  0x3fff7ffe, 0x55545556, 0x00000000, 0x0000ff80,
  0x5553aaac, 0x66653334, 0x00000000, 0x0000ff81,
  0x66646668, 0x7fbf0080, 0x00000000, 0x0000ff82,
  0x7fbe0100, 0x7fbf807f, 0x00000000, 0x0000ff83,
  0x7fbf807f, 0x00000000, 0x0000ff83, 0x0001ffe0,
  0x7fc0007e, 0x00000000, 0x0000fff0, 0x0001fffa,
  0x7fc0807d, 0x00000000, 0x0000fffd, 0x0001fffc,
  0x7ff70010, 0x00000000, 0x0000fffe, 0x0001fffe,
  0x7ffd8003, 0x00000000, 0x0000ffff, 0x00000000,
  0x7ffe0002, 0x00000000, 0x00000000, 0x00000002,
  0x7ffe8001, 0x00000000, 0x00000001, 0x00000004,
  0x00000000, 0x00000000, 0x00000002, 0x00000020,
  0x00007fff, 0x00000000, 0x00000010, 0x000000fa,
  0x0000fffe, 0x00000000, 0x0000007d, 0x000000fc,
  0x0007fff0, 0x00000000, 0x0000007e, 0x000000fe,
  0x003e7f83, 0x00000000, 0x0000007f, 0x00006666,
  0x003eff82, 0x00000000, 0x00003333, 0x0000aaaa,
  0x003f7f81, 0x00000000, 0x00005555, 0x0000fffa,
  0x19994ccd, 0x00000000, 0x00007ffd, 0x0000fffc,
  0x2aaa2aab, 0x00000000, 0x00007ffe, 0x0000fffe,
  0x3ffe0003, 0x00000000, 0x00007fff, 0x00010000,
  0x3ffe8002, 0x00000000, 0x00008000, 0x00010002,
  0x3fff0001, 0x00000000, 0x00008001, 0x00015554,
  0x3fff8000, 0x00000000, 0x0000aaaa, 0x00019998,
  0x3fffffff, 0x00000000, 0x0000cccc, 0x0001ff00,
  0x55545556, 0x00000000, 0x0000ff80, 0x0001ff02,
  0x66653334, 0x00000000, 0x0000ff81, 0x0001ff04,
  0x7fbf0080, 0x00000000, 0x0000ff82, 0x0001ff06,
  0x00000000, 0x0000ff82, 0x0001ff06, 0x000fff00,
  0x00000000, 0x0000ff83, 0x0001ffe0, 0x000fffd0,
  0x00000000, 0x0000fff0, 0x0001fffa, 0x000fffe0,
  0x00000000, 0x0000fffd, 0x0001fffc, 0x000ffff0,
  0x00000000, 0x0000fffe, 0x0001fffe, 0x00000000,
  0x00000000, 0x0000ffff, 0x00000000, 0x00000010,
  0x00000000, 0x00000000, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000004, 0x00000100,
  0x00000000, 0x00000002, 0x00000020, 0x000007d0,
  0x00000000, 0x00000010, 0x000000fa, 0x000007e0,
  0x00000000, 0x0000007d, 0x000000fc, 0x000007f0,
  0x00000000, 0x0000007e, 0x000000fe, 0x00033330,
  0x00000000, 0x0000007f, 0x00006666, 0x00055550,
  0x00000000, 0x00003333, 0x0000aaaa, 0x0007ffd0,
  0x00000000, 0x00005555, 0x0000fffa, 0x0007ffe0,
  0x00000000, 0x00007ffd, 0x0000fffc, 0x0007fff0,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x00080000,
  0x00000000, 0x00007fff, 0x00010000, 0x00080010,
  0x00000000, 0x00008000, 0x00010002, 0x000aaaa0,
  0x00000000, 0x00008001, 0x00015554, 0x000cccc0,
  0x00000000, 0x0000aaaa, 0x00019998, 0x000ff800,
  0x00000000, 0x0000cccc, 0x0001ff00, 0x000ff810,
  0x00000000, 0x0000ff80, 0x0001ff02, 0x000ff820,
  0x00000000, 0x0000ff81, 0x0001ff04, 0x000ff830,
  0x0000ff81, 0x0001ff04, 0x000ff830, 0x007cf830,
  0x0000ff82, 0x0001ff06, 0x000fff00, 0x007cfe89,
  0x0000ff83, 0x0001ffe0, 0x000fffd0, 0x007cff06,
  0x0000fff0, 0x0001fffa, 0x000fffe0, 0x007cff83,
  0x0000fffd, 0x0001fffc, 0x000ffff0, 0x00000000,
  0x0000fffe, 0x0001fffe, 0x00000000, 0x0000007d,
  0x0000ffff, 0x00000000, 0x00000010, 0x000000fa,
  0x00000000, 0x00000002, 0x00000020, 0x000007d0,
  0x00000001, 0x00000004, 0x00000100, 0x00003d09,
  0x00000002, 0x00000020, 0x000007d0, 0x00003d86,
  0x00000010, 0x000000fa, 0x000007e0, 0x00003e03,
  0x0000007d, 0x000000fc, 0x000007f0, 0x0018ffe7,
  0x0000007e, 0x000000fe, 0x00033330, 0x0029aa81,
  0x0000007f, 0x00006666, 0x00055550, 0x003e7e89,
  0x00003333, 0x0000aaaa, 0x0007ffd0, 0x003e7f06,
  0x00005555, 0x0000fffa, 0x0007ffe0, 0x003e7f83,
  0x00007ffd, 0x0000fffc, 0x0007fff0, 0x003e8000,
  0x00007ffe, 0x0000fffe, 0x00080000, 0x003e807d,
  0x00007fff, 0x00010000, 0x00080010, 0x00535502,
  0x00008000, 0x00010002, 0x000aaaa0, 0x0063ff9c,
  0x00008001, 0x00015554, 0x000cccc0, 0x007cc180,
  0x0000aaaa, 0x00019998, 0x000ff800, 0x007cc1fd,
  0x0000cccc, 0x0001ff00, 0x000ff810, 0x007cc27a,
  0x0000ff80, 0x0001ff02, 0x000ff820, 0x007cc2f7,
  0x0001ff02, 0x000ff820, 0x007cc2f7, 0x007df820,
  0x0001ff04, 0x000ff830, 0x007cf830, 0x007dfe86,
  0x0001ff06, 0x000fff00, 0x007cfe89, 0x007dff04,
  0x0001ffe0, 0x000fffd0, 0x007cff06, 0x007dff82,
  0x0001fffa, 0x000fffe0, 0x007cff83, 0x00000000,
  0x0001fffc, 0x000ffff0, 0x00000000, 0x0000007e,
  0x0001fffe, 0x00000000, 0x0000007d, 0x000000fc,
  0x00000000, 0x00000010, 0x000000fa, 0x000007e0,
  0x00000002, 0x00000020, 0x000007d0, 0x00003d86,
  0x00000004, 0x00000100, 0x00003d09, 0x00003e04,
  0x00000020, 0x000007d0, 0x00003d86, 0x00003e82,
  0x000000fa, 0x000007e0, 0x00003e03, 0x0019331a,
  0x000000fc, 0x000007f0, 0x0018ffe7, 0x0029ffd6,
  0x000000fe, 0x00033330, 0x0029aa81, 0x003efe86,
  0x00006666, 0x00055550, 0x003e7e89, 0x003eff04,
  0x0000aaaa, 0x0007ffd0, 0x003e7f06, 0x003eff82,
  0x0000fffa, 0x0007ffe0, 0x003e7f83, 0x003f0000,
  0x0000fffc, 0x0007fff0, 0x003e8000, 0x003f007e,
  0x0000fffe, 0x00080000, 0x003e807d, 0x0053ffac,
  0x00010000, 0x00080010, 0x00535502, 0x0064cc68,
  0x00010002, 0x000aaaa0, 0x0063ff9c, 0x007dc100,
  0x00015554, 0x000cccc0, 0x007cc180, 0x007dc17e,
  0x00019998, 0x000ff800, 0x007cc1fd, 0x007dc1fc,
  0x0001ff00, 0x000ff810, 0x007cc27a, 0x007dc27a,
  0x000ff810, 0x007cc27a, 0x007dc27a, 0x007ef810,
  0x000ff820, 0x007cc2f7, 0x007df820, 0x007efe83,
  0x000ff830, 0x007cf830, 0x007dfe86, 0x007eff02,
  0x000fff00, 0x007cfe89, 0x007dff04, 0x007eff81,
  0x000fffd0, 0x007cff06, 0x007dff82, 0x00000000,
  0x000fffe0, 0x007cff83, 0x00000000, 0x0000007f,
  0x000ffff0, 0x00000000, 0x0000007e, 0x000000fe,
  0x00000000, 0x0000007d, 0x000000fc, 0x000007f0,
  0x00000010, 0x000000fa, 0x000007e0, 0x00003e03,
  0x00000020, 0x000007d0, 0x00003d86, 0x00003e82,
  0x00000100, 0x00003d09, 0x00003e04, 0x00003f01,
  0x000007d0, 0x00003d86, 0x00003e82, 0x0019664d,
  0x000007e0, 0x00003e03, 0x0019331a, 0x002a552b,
  0x000007f0, 0x0018ffe7, 0x0029ffd6, 0x003f7e83,
  0x00033330, 0x0029aa81, 0x003efe86, 0x003f7f02,
  0x00055550, 0x003e7e89, 0x003eff04, 0x003f7f81,
  0x0007ffd0, 0x003e7f06, 0x003eff82, 0x003f8000,
  0x0007ffe0, 0x003e7f83, 0x003f0000, 0x003f807f,
  0x0007fff0, 0x003e8000, 0x003f007e, 0x0054aa56,
  0x00080000, 0x003e807d, 0x0053ffac, 0x00659934,
  0x00080010, 0x00535502, 0x0064cc68, 0x007ec080,
  0x000aaaa0, 0x0063ff9c, 0x007dc100, 0x007ec0ff,
  0x000cccc0, 0x007cc180, 0x007dc17e, 0x007ec17e,
  0x000ff800, 0x007cc1fd, 0x007dc1fc, 0x007ec1fd,
  0x007cc1fd, 0x007dc1fc, 0x007ec1fd, 0x332fccd0,
  0x007cc27a, 0x007dc27a, 0x007ef810, 0x33326667,
  0x007cc2f7, 0x007df820, 0x007efe83, 0x3332999a,
  0x007cf830, 0x007dfe86, 0x007eff02, 0x3332cccd,
  0x007cfe89, 0x007dff04, 0x007eff81, 0x00000000,
  0x007cff06, 0x007dff82, 0x00000000, 0x00003333,
  0x007cff83, 0x00000000, 0x0000007f, 0x00006666,
  0x00000000, 0x0000007e, 0x000000fe, 0x00033330,
  0x0000007d, 0x000000fc, 0x000007f0, 0x0018ffe7,
  0x000000fa, 0x000007e0, 0x00003e03, 0x0019331a,
  0x000007d0, 0x00003d86, 0x00003e82, 0x0019664d,
  0x00003d09, 0x00003e04, 0x00003f01, 0x0a3d5c29,
  0x00003d86, 0x00003e82, 0x0019664d, 0x1110eeef,
  0x00003e03, 0x0019331a, 0x002a552b, 0x1998e667,
  0x0018ffe7, 0x0029ffd6, 0x003f7e83, 0x1999199a,
  0x0029aa81, 0x003efe86, 0x003f7f02, 0x19994ccd,
  0x003e7e89, 0x003eff04, 0x003f7f81, 0x19998000,
  0x003e7f06, 0x003eff82, 0x003f8000, 0x1999b333,
  0x003e7f83, 0x003f0000, 0x003f807f, 0x2221ddde,
  0x003e8000, 0x003f007e, 0x0054aa56, 0x28f570a4,
  0x003e807d, 0x0053ffac, 0x00659934, 0x33196680,
  0x00535502, 0x0064cc68, 0x007ec080, 0x331999b3,
  0x0063ff9c, 0x007dc100, 0x007ec0ff, 0x3319cce6,
  0x007cc180, 0x007dc17e, 0x007ec17e, 0x331a0019,
  0x007dc17e, 0x007ec17e, 0x331a0019, 0x554faab0,
  0x007dc1fc, 0x007ec1fd, 0x332fccd0, 0x55540001,
  0x007dc27a, 0x007ef810, 0x33326667, 0x55545556,
  0x007df820, 0x007efe83, 0x3332999a, 0x5554aaab,
  0x007dfe86, 0x007eff02, 0x3332cccd, 0x00000000,
  0x007dff04, 0x007eff81, 0x00000000, 0x00005555,
  0x007dff82, 0x00000000, 0x00003333, 0x0000aaaa,
  0x00000000, 0x0000007f, 0x00006666, 0x00055550,
  0x0000007e, 0x000000fe, 0x00033330, 0x0029aa81,
  0x000000fc, 0x000007f0, 0x0018ffe7, 0x0029ffd6,
  0x000007e0, 0x00003e03, 0x0019331a, 0x002a552b,
  0x00003d86, 0x00003e82, 0x0019664d, 0x1110eeef,
  0x00003e04, 0x00003f01, 0x0a3d5c29, 0x1c718e39,
  0x00003e82, 0x0019664d, 0x1110eeef, 0x2aa98001,
  0x0019331a, 0x002a552b, 0x1998e667, 0x2aa9d556,
  0x0029ffd6, 0x003f7e83, 0x1999199a, 0x2aaa2aab,
  0x003efe86, 0x003f7f02, 0x19994ccd, 0x2aaa8000,
  0x003eff04, 0x003f7f81, 0x19998000, 0x2aaad555,
  0x003eff82, 0x003f8000, 0x1999b333, 0x38e31c72,
  0x003f0000, 0x003f807f, 0x2221ddde, 0x4443bbbc,
  0x003f007e, 0x0054aa56, 0x28f570a4, 0x552a5580,
  0x0053ffac, 0x00659934, 0x33196680, 0x552aaad5,
  0x0064cc68, 0x007ec080, 0x331999b3, 0x552b002a,
  0x007dc100, 0x007ec0ff, 0x3319cce6, 0x552b557f,
  0x007ec0ff, 0x3319cce6, 0x552b557f, 0x7ff50030,
  0x007ec17e, 0x331a0019, 0x554faab0, 0x7ffb8009,
  0x007ec1fd, 0x332fccd0, 0x55540001, 0x7ffc0006,
  0x007ef810, 0x33326667, 0x55545556, 0x7ffc8003,
  0x007efe83, 0x3332999a, 0x5554aaab, 0x00000000,
  0x007eff02, 0x3332cccd, 0x00000000, 0x00007ffd,
  0x007eff81, 0x00000000, 0x00005555, 0x0000fffa,
  0x00000000, 0x00003333, 0x0000aaaa, 0x0007ffd0,
  0x0000007f, 0x00006666, 0x00055550, 0x003e7e89,
  0x000000fe, 0x00033330, 0x0029aa81, 0x003efe86,
  0x000007f0, 0x0018ffe7, 0x0029ffd6, 0x003f7e83,
  0x00003e03, 0x0019331a, 0x002a552b, 0x1998e667,
  0x00003e82, 0x0019664d, 0x1110eeef, 0x2aa98001,
  0x00003f01, 0x0a3d5c29, 0x1c718e39, 0x3ffd0009,
  0x0019664d, 0x1110eeef, 0x2aa98001, 0x3ffd8006,
  0x002a552b, 0x1998e667, 0x2aa9d556, 0x3ffe0003,
  0x003f7e83, 0x1999199a, 0x2aaa2aab, 0x3ffe8000,
  0x003f7f02, 0x19994ccd, 0x2aaa8000, 0x3ffefffd,
  0x003f7f81, 0x19998000, 0x2aaad555, 0x55530002,
  0x003f8000, 0x1999b333, 0x38e31c72, 0x6663999c,
  0x003f807f, 0x2221ddde, 0x4443bbbc, 0x7fbd0180,
  0x0054aa56, 0x28f570a4, 0x552a5580, 0x7fbd817d,
  0x00659934, 0x33196680, 0x552aaad5, 0x7fbe017a,
  0x007ec080, 0x331999b3, 0x552b002a, 0x7fbe8177,
  0x331999b3, 0x552b002a, 0x7fbe8177, 0x7ff60020,
  0x3319cce6, 0x552b557f, 0x7ff50030, 0x7ffc8006,
  0x331a0019, 0x554faab0, 0x7ffb8009, 0x7ffd0004,
  0x332fccd0, 0x55540001, 0x7ffc0006, 0x7ffd8002,
  0x33326667, 0x55545556, 0x7ffc8003, 0x00000000,
  0x3332999a, 0x5554aaab, 0x00000000, 0x00007ffe,
  0x3332cccd, 0x00000000, 0x00007ffd, 0x0000fffc,
  0x00000000, 0x00005555, 0x0000fffa, 0x0007ffe0,
  0x00003333, 0x0000aaaa, 0x0007ffd0, 0x003e7f06,
  0x00006666, 0x00055550, 0x003e7e89, 0x003eff04,
  0x00033330, 0x0029aa81, 0x003efe86, 0x003f7f02,
  0x0018ffe7, 0x0029ffd6, 0x003f7e83, 0x1999199a,
  0x0019331a, 0x002a552b, 0x1998e667, 0x2aa9d556,
  0x0019664d, 0x1110eeef, 0x2aa98001, 0x3ffd8006,
  0x0a3d5c29, 0x1c718e39, 0x3ffd0009, 0x3ffe0004,
  0x1110eeef, 0x2aa98001, 0x3ffd8006, 0x3ffe8002,
  0x1998e667, 0x2aa9d556, 0x3ffe0003, 0x3fff0000,
  0x1999199a, 0x2aaa2aab, 0x3ffe8000, 0x3fff7ffe,
  0x19994ccd, 0x2aaa8000, 0x3ffefffd, 0x5553aaac,
  0x19998000, 0x2aaad555, 0x55530002, 0x66646668,
  0x1999b333, 0x38e31c72, 0x6663999c, 0x7fbe0100,
  0x2221ddde, 0x4443bbbc, 0x7fbd0180, 0x7fbe80fe,
  0x28f570a4, 0x552a5580, 0x7fbd817d, 0x7fbf00fc,
  0x33196680, 0x552aaad5, 0x7fbe017a, 0x7fbf80fa,
  0x552aaad5, 0x7fbe017a, 0x7fbf80fa, 0x7ff70010,
  0x552b002a, 0x7fbe8177, 0x7ff60020, 0x7ffd8003,
  0x552b557f, 0x7ff50030, 0x7ffc8006, 0x7ffe0002,
  0x554faab0, 0x7ffb8009, 0x7ffd0004, 0x7ffe8001,
  0x55540001, 0x7ffc0006, 0x7ffd8002, 0x00000000,
  0x55545556, 0x7ffc8003, 0x00000000, 0x00007fff,
  0x5554aaab, 0x00000000, 0x00007ffe, 0x0000fffe,
  0x00000000, 0x00007ffd, 0x0000fffc, 0x0007fff0,
  0x00005555, 0x0000fffa, 0x0007ffe0, 0x003e7f83,
  0x0000aaaa, 0x0007ffd0, 0x003e7f06, 0x003eff82,
  0x00055550, 0x003e7e89, 0x003eff04, 0x003f7f81,
  0x0029aa81, 0x003efe86, 0x003f7f02, 0x19994ccd,
  0x0029ffd6, 0x003f7e83, 0x1999199a, 0x2aaa2aab,
  0x002a552b, 0x1998e667, 0x2aa9d556, 0x3ffe0003,
  0x1110eeef, 0x2aa98001, 0x3ffd8006, 0x3ffe8002,
  0x1c718e39, 0x3ffd0009, 0x3ffe0004, 0x3fff0001,
  0x2aa98001, 0x3ffd8006, 0x3ffe8002, 0x3fff8000,
  0x2aa9d556, 0x3ffe0003, 0x3fff0000, 0x3fffffff,
  0x2aaa2aab, 0x3ffe8000, 0x3fff7ffe, 0x55545556,
  0x2aaa8000, 0x3ffefffd, 0x5553aaac, 0x66653334,
  0x2aaad555, 0x55530002, 0x66646668, 0x7fbf0080,
  0x38e31c72, 0x6663999c, 0x7fbe0100, 0x7fbf807f,
  0x4443bbbc, 0x7fbd0180, 0x7fbe80fe, 0x7fc0007e,
  0x552a5580, 0x7fbd817d, 0x7fbf00fc, 0x7fc0807d,
  0x7fbd817d, 0x7fbf00fc, 0x7fc0807d, 0x7ff80000,
  0x7fbe017a, 0x7fbf80fa, 0x7ff70010, 0x7ffe8000,
  0x7fbe8177, 0x7ff60020, 0x7ffd8003, 0x7fff0000,
  0x7ff50030, 0x7ffc8006, 0x7ffe0002, 0x7fff8000,
  0x7ffb8009, 0x7ffd0004, 0x7ffe8001, 0x00000000,
  0x7ffc0006, 0x7ffd8002, 0x00000000, 0x00008000,
  0x7ffc8003, 0x00000000, 0x00007fff, 0x00010000,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x00080000,
  0x00007ffd, 0x0000fffc, 0x0007fff0, 0x003e8000,
  0x0000fffa, 0x0007ffe0, 0x003e7f83, 0x003f0000,
  0x0007ffd0, 0x003e7f06, 0x003eff82, 0x003f8000,
  0x003e7e89, 0x003eff04, 0x003f7f81, 0x19998000,
  0x003efe86, 0x003f7f02, 0x19994ccd, 0x2aaa8000,
  0x003f7e83, 0x1999199a, 0x2aaa2aab, 0x3ffe8000,
  0x1998e667, 0x2aa9d556, 0x3ffe0003, 0x3fff0000,
  0x2aa98001, 0x3ffd8006, 0x3ffe8002, 0x3fff8000,
  0x3ffd0009, 0x3ffe0004, 0x3fff0001, 0x40000000,
  0x3ffd8006, 0x3ffe8002, 0x3fff8000, 0x40008000,
  0x3ffe0003, 0x3fff0000, 0x3fffffff, 0x55550000,
  0x3ffe8000, 0x3fff7ffe, 0x55545556, 0x66660000,
  0x3ffefffd, 0x5553aaac, 0x66653334, 0x7fc00000,
  0x55530002, 0x66646668, 0x7fbf0080, 0x7fc08000,
  0x6663999c, 0x7fbe0100, 0x7fbf807f, 0x7fc10000,
  0x7fbd0180, 0x7fbe80fe, 0x7fc0007e, 0x7fc18000,
  0x7fbe80fe, 0x7fc0007e, 0x7fc18000, 0x7ff8fff0,
  0x7fbf00fc, 0x7fc0807d, 0x7ff80000, 0x7fff7ffd,
  0x7fbf80fa, 0x7ff70010, 0x7ffe8000, 0x7ffffffe,
  0x7ff60020, 0x7ffd8003, 0x7fff0000, 0x80007fff,
  0x7ffc8006, 0x7ffe0002, 0x7fff8000, 0x00000000,
  0x7ffd0004, 0x7ffe8001, 0x00000000, 0x00008001,
  0x7ffd8002, 0x00000000, 0x00008000, 0x00010002,
  0x00000000, 0x00007fff, 0x00010000, 0x00080010,
  0x00007ffe, 0x0000fffe, 0x00080000, 0x003e807d,
  0x0000fffc, 0x0007fff0, 0x003e8000, 0x003f007e,
  0x0007ffe0, 0x003e7f83, 0x003f0000, 0x003f807f,
  0x003e7f06, 0x003eff82, 0x003f8000, 0x1999b333,
  0x003eff04, 0x003f7f81, 0x19998000, 0x2aaad555,
  0x003f7f02, 0x19994ccd, 0x2aaa8000, 0x3ffefffd,
  0x1999199a, 0x2aaa2aab, 0x3ffe8000, 0x3fff7ffe,
  0x2aa9d556, 0x3ffe0003, 0x3fff0000, 0x3fffffff,
  0x3ffd8006, 0x3ffe8002, 0x3fff8000, 0x40008000,
  0x3ffe0004, 0x3fff0001, 0x40000000, 0x40010001,
  0x3ffe8002, 0x3fff8000, 0x40008000, 0x5555aaaa,
  0x3fff0000, 0x3fffffff, 0x55550000, 0x6666cccc,
  0x3fff7ffe, 0x55545556, 0x66660000, 0x7fc0ff80,
  0x5553aaac, 0x66653334, 0x7fc00000, 0x7fc17f81,
  0x66646668, 0x7fbf0080, 0x7fc08000, 0x7fc1ff82,
  0x7fbe0100, 0x7fbf807f, 0x7fc10000, 0x7fc27f83,
  0x7fbf807f, 0x7fc10000, 0x7fc27f83, 0xaa9f5560,
  0x7fc0007e, 0x7fc18000, 0x7ff8fff0, 0xaaa80002,
  0x7fc0807d, 0x7ff80000, 0x7fff7ffd, 0xaaa8aaac,
  0x7ff70010, 0x7ffe8000, 0x7ffffffe, 0xaaa95556,
  0x7ffd8003, 0x7fff0000, 0x80007fff, 0x00000000,
  0x7ffe0002, 0x7fff8000, 0x00000000, 0x0000aaaa,
  0x7ffe8001, 0x00000000, 0x00008001, 0x00015554,
  0x00000000, 0x00008000, 0x00010002, 0x000aaaa0,
  0x00007fff, 0x00010000, 0x00080010, 0x00535502,
  0x0000fffe, 0x00080000, 0x003e807d, 0x0053ffac,
  0x0007fff0, 0x003e8000, 0x003f007e, 0x0054aa56,
  0x003e7f83, 0x003f0000, 0x003f807f, 0x2221ddde,
  0x003eff82, 0x003f8000, 0x1999b333, 0x38e31c72,
  0x003f7f81, 0x19998000, 0x2aaad555, 0x55530002,
  0x19994ccd, 0x2aaa8000, 0x3ffefffd, 0x5553aaac,
  0x2aaa2aab, 0x3ffe8000, 0x3fff7ffe, 0x55545556,
  0x3ffe0003, 0x3fff0000, 0x3fffffff, 0x55550000,
  0x3ffe8002, 0x3fff8000, 0x40008000, 0x5555aaaa,
  0x3fff0001, 0x40000000, 0x40010001, 0x71c638e4,
  0x3fff8000, 0x40008000, 0x5555aaaa, 0x88877778,
  0x3fffffff, 0x55550000, 0x6666cccc, 0xaa54ab00,
  0x55545556, 0x66660000, 0x7fc0ff80, 0xaa5555aa,
  0x66653334, 0x7fc00000, 0x7fc17f81, 0xaa560054,
  0x7fbf0080, 0x7fc08000, 0x7fc1ff82, 0xaa56aafe,
  0x7fc08000, 0x7fc1ff82, 0xaa56aafe, 0xccbf3340,
  0x7fc10000, 0x7fc27f83, 0xaa9f5560, 0xccc9999c,
  0x7fc18000, 0x7ff8fff0, 0xaaa80002, 0xccca6668,
  0x7ff80000, 0x7fff7ffd, 0xaaa8aaac, 0xcccb3334,
  0x7ffe8000, 0x7ffffffe, 0xaaa95556, 0x00000000,
  0x7fff0000, 0x80007fff, 0x00000000, 0x0000cccc,
  0x7fff8000, 0x00000000, 0x0000aaaa, 0x00019998,
  0x00000000, 0x00008001, 0x00015554, 0x000cccc0,
  0x00008000, 0x00010002, 0x000aaaa0, 0x0063ff9c,
  0x00010000, 0x00080010, 0x00535502, 0x0064cc68,
  0x00080000, 0x003e807d, 0x0053ffac, 0x00659934,
  0x003e8000, 0x003f007e, 0x0054aa56, 0x28f570a4,
  0x003f0000, 0x003f807f, 0x2221ddde, 0x4443bbbc,
  0x003f8000, 0x1999b333, 0x38e31c72, 0x6663999c,
  0x19998000, 0x2aaad555, 0x55530002, 0x66646668,
  0x2aaa8000, 0x3ffefffd, 0x5553aaac, 0x66653334,
  0x3ffe8000, 0x3fff7ffe, 0x55545556, 0x66660000,
  0x3fff0000, 0x3fffffff, 0x55550000, 0x6666cccc,
  0x3fff8000, 0x40008000, 0x5555aaaa, 0x88877778,
  0x40000000, 0x40010001, 0x71c638e4, 0xa3d5c290,
  0x40008000, 0x5555aaaa, 0x88877778, 0xcc659a00,
  0x55550000, 0x6666cccc, 0xaa54ab00, 0xcc6666cc,
  0x66660000, 0x7fc0ff80, 0xaa5555aa, 0xcc673398,
  0x7fc00000, 0x7fc17f81, 0xaa560054, 0xcc680064,
  0x7fc17f81, 0xaa560054, 0xcc680064, 0xff700800,
  0x7fc1ff82, 0xaa56aafe, 0xccbf3340, 0xff7d0180,
  0x7fc27f83, 0xaa9f5560, 0xccc9999c, 0xff7e0100,
  0x7ff8fff0, 0xaaa80002, 0xccca6668, 0xff7f0080,
  0x7fff7ffd, 0xaaa8aaac, 0xcccb3334, 0x00000000,
  0x7ffffffe, 0xaaa95556, 0x00000000, 0x0000ff80,
  0x80007fff, 0x00000000, 0x0000cccc, 0x0001ff00,
  0x00000000, 0x0000aaaa, 0x00019998, 0x000ff800,
  0x00008001, 0x00015554, 0x000cccc0, 0x007cc180,
  0x00010002, 0x000aaaa0, 0x0063ff9c, 0x007dc100,
  0x00080010, 0x00535502, 0x0064cc68, 0x007ec080,
  0x003e807d, 0x0053ffac, 0x00659934, 0x33196680,
  0x003f007e, 0x0054aa56, 0x28f570a4, 0x552a5580,
  0x003f807f, 0x2221ddde, 0x4443bbbc, 0x7fbd0180,
  0x1999b333, 0x38e31c72, 0x6663999c, 0x7fbe0100,
  0x2aaad555, 0x55530002, 0x66646668, 0x7fbf0080,
  0x3ffefffd, 0x5553aaac, 0x66653334, 0x7fc00000,
  0x3fff7ffe, 0x55545556, 0x66660000, 0x7fc0ff80,
  0x3fffffff, 0x55550000, 0x6666cccc, 0xaa54ab00,
  0x40008000, 0x5555aaaa, 0x88877778, 0xcc659a00,
  0x40010001, 0x71c638e4, 0xa3d5c290, 0xff004000,
  0x5555aaaa, 0x88877778, 0xcc659a00, 0xff013f80,
  0x6666cccc, 0xaa54ab00, 0xcc6666cc, 0xff023f00,
  0x7fc0ff80, 0xaa5555aa, 0xcc673398, 0xff033e80,
  0xaa5555aa, 0xcc673398, 0xff033e80, 0xff7107f0,
  0xaa560054, 0xcc680064, 0xff700800, 0xff7e017d,
  0xaa56aafe, 0xccbf3340, 0xff7d0180, 0xff7f00fe,
  0xaa9f5560, 0xccc9999c, 0xff7e0100, 0xff80007f,
  0xaaa80002, 0xccca6668, 0xff7f0080, 0x00000000,
  0xaaa8aaac, 0xcccb3334, 0x00000000, 0x0000ff81,
  0xaaa95556, 0x00000000, 0x0000ff80, 0x0001ff02,
  0x00000000, 0x0000cccc, 0x0001ff00, 0x000ff810,
  0x0000aaaa, 0x00019998, 0x000ff800, 0x007cc1fd,
  0x00015554, 0x000cccc0, 0x007cc180, 0x007dc17e,
  0x000aaaa0, 0x0063ff9c, 0x007dc100, 0x007ec0ff,
  0x00535502, 0x0064cc68, 0x007ec080, 0x331999b3,
  0x0053ffac, 0x00659934, 0x33196680, 0x552aaad5,
  0x0054aa56, 0x28f570a4, 0x552a5580, 0x7fbd817d,
  0x2221ddde, 0x4443bbbc, 0x7fbd0180, 0x7fbe80fe,
  0x38e31c72, 0x6663999c, 0x7fbe0100, 0x7fbf807f,
  0x55530002, 0x66646668, 0x7fbf0080, 0x7fc08000,
  0x5553aaac, 0x66653334, 0x7fc00000, 0x7fc17f81,
  0x55545556, 0x66660000, 0x7fc0ff80, 0xaa5555aa,
  0x55550000, 0x6666cccc, 0xaa54ab00, 0xcc6666cc,
  0x5555aaaa, 0x88877778, 0xcc659a00, 0xff013f80,
  0x71c638e4, 0xa3d5c290, 0xff004000, 0xff023f01,
  0x88877778, 0xcc659a00, 0xff013f80, 0xff033e82,
  0xaa54ab00, 0xcc6666cc, 0xff023f00, 0xff043e03,
  0xcc6666cc, 0xff023f00, 0xff043e03, 0xff7207e0,
  0xcc673398, 0xff033e80, 0xff7107f0, 0xff7f017a,
  0xcc680064, 0xff700800, 0xff7e017d, 0xff8000fc,
  0xccbf3340, 0xff7d0180, 0xff7f00fe, 0xff81007e,
  0xccc9999c, 0xff7e0100, 0xff80007f, 0x00000000,
  0xccca6668, 0xff7f0080, 0x00000000, 0x0000ff82,
  0xcccb3334, 0x00000000, 0x0000ff81, 0x0001ff04,
  0x00000000, 0x0000ff80, 0x0001ff02, 0x000ff820,
  0x0000cccc, 0x0001ff00, 0x000ff810, 0x007cc27a,
  0x00019998, 0x000ff800, 0x007cc1fd, 0x007dc1fc,
  0x000cccc0, 0x007cc180, 0x007dc17e, 0x007ec17e,
  0x0063ff9c, 0x007dc100, 0x007ec0ff, 0x3319cce6,
  0x0064cc68, 0x007ec080, 0x331999b3, 0x552b002a,
  0x00659934, 0x33196680, 0x552aaad5, 0x7fbe017a,
  0x28f570a4, 0x552a5580, 0x7fbd817d, 0x7fbf00fc,
  0x4443bbbc, 0x7fbd0180, 0x7fbe80fe, 0x7fc0007e,
  0x6663999c, 0x7fbe0100, 0x7fbf807f, 0x7fc10000,
  0x66646668, 0x7fbf0080, 0x7fc08000, 0x7fc1ff82,
  0x66653334, 0x7fc00000, 0x7fc17f81, 0xaa560054,
  0x66660000, 0x7fc0ff80, 0xaa5555aa, 0xcc673398,
  0x6666cccc, 0xaa54ab00, 0xcc6666cc, 0xff023f00,
  0x88877778, 0xcc659a00, 0xff013f80, 0xff033e82,
  0xa3d5c290, 0xff004000, 0xff023f01, 0xff043e04,
  0xcc659a00, 0xff013f80, 0xff033e82, 0xff053d86,
  0xff013f80, 0xff033e82, 0xff053d86, 0xff7307d0,
  0xff023f00, 0xff043e03, 0xff7207e0, 0xff800177,
  0xff033e80, 0xff7107f0, 0xff7f017a, 0xff8100fa,
  0xff700800, 0xff7e017d, 0xff8000fc, 0xff82007d,
  0xff7d0180, 0xff7f00fe, 0xff81007e, 0x00000000,
  0xff7e0100, 0xff80007f, 0x00000000, 0x0000ff83,
  0xff7f0080, 0x00000000, 0x0000ff82, 0x0001ff06,
  0x00000000, 0x0000ff81, 0x0001ff04, 0x000ff830,
  0x0000ff80, 0x0001ff02, 0x000ff820, 0x007cc2f7,
  0x0001ff00, 0x000ff810, 0x007cc27a, 0x007dc27a,
  0x000ff800, 0x007cc1fd, 0x007dc1fc, 0x007ec1fd,
  0x007cc180, 0x007dc17e, 0x007ec17e, 0x331a0019,
  0x007dc100, 0x007ec0ff, 0x3319cce6, 0x552b557f,
  0x007ec080, 0x331999b3, 0x552b002a, 0x7fbe8177,
  0x33196680, 0x552aaad5, 0x7fbe017a, 0x7fbf80fa,
  0x552a5580, 0x7fbd817d, 0x7fbf00fc, 0x7fc0807d,
  0x7fbd0180, 0x7fbe80fe, 0x7fc0007e, 0x7fc18000,
  0x7fbe0100, 0x7fbf807f, 0x7fc10000, 0x7fc27f83,
  0x7fbf0080, 0x7fc08000, 0x7fc1ff82, 0xaa56aafe,
  0x7fc00000, 0x7fc17f81, 0xaa560054, 0xcc680064,
  0x7fc0ff80, 0xaa5555aa, 0xcc673398, 0xff033e80,
  0xaa54ab00, 0xcc6666cc, 0xff023f00, 0xff043e03,
  0xcc659a00, 0xff013f80, 0xff033e82, 0xff053d86,
  0xff004000, 0xff023f01, 0xff043e04, 0xff063d09,
};
const unsigned kExpectedCount_NEON_umull_4S = 576;

#endif  // VIXL_SIM_UMULL_4S_TRACE_AARCH64_H_
