#!/bin/sh

set -e

DESTDIR=${DESTDIR:-../tarballs}
MODULE=CGI-Application-Plugin-Authorization
PACKAGE=libcgi-application-plugin-authorization-perl
VERSION=0.07
AD_VERS=0.01
D_AD=driver-ad
FD=--force-download
NS=--no-symlink
RE=--rename
DD="--destdir ${DESTDIR}"
RS=--report-status
DC=-"-watch debian/components"
US=--upstream-version

if [ $1 ]
then
    echo update;
    rm -f ${DESTDIR}/${MODULE}*.tar.gz
    uscan ${FD} ${RE} ${DD} && true;
    uscan ${DC}/${D_AD}/watch ${FD} ${NS} ${DD} ${US} ${AD_VERS} && true;
    cd ${DESTDIR}
    AD=`ls ${MODULE}-Driver-ActiveDirectory*.tar.gz`
    mv ${AD} ${PACKAGE}_${VERSION}.orig-${D_AD}.tar.gz
    cd -
else
    echo report;
    uscan ${RS} && true;
    uscan ${DC}/${D_AD}/watch ${RS} ${DD} ${US} ${AD_VERS} && true;
fi
